/* -*- Mode:C; Tab-width:4 -*- */
/*                                                                       */
/*                                                                       */
/*                      RESTRICTED RIGHTS LEGEND                         */
/*                                                                       */
/* Use, duplication, or disclosure by the Government is subject to       */
/* restrictions as set forth in subdivision (c)(1)(ii) of the Rights in  */
/* Technical Data and Computer Software clause at 252.227-7013.          */
/*                                                                       */
/*                    TEXAS INSTRUMENTS INCORPORATED.                    */
/*                            P.O. BOX 149149                            */
/*                         AUSTIN, TEXAS 78714-9149                      */
/*                              MS 2151                                  */
/*                                                                       */
/*  Copyright (C) 1987,1988,1989,1990 Texas Instruments Incorporated.    */
/*  All rights reserved.                                                 */
/*                                                                       */

/* clm 10/04/89 - added STR resource 229 for LG  */
/* clm 10/27/89 - the FONT resources were DeRez'd from the previous driver */
/* (created under MPW 2.0.2).   */
/* sbw 12/01/89 - Removed type definitions 'SIZE' and 'vers';  we are now	*/
/*    using the mpw 3.0 definitions.	*/
/* sbw 05/23/90 - Moved all CPT, CPTVARIABLE, and BIG FONT and FOND resources 
      to MICRONET-FONTS.R. */

#include "Types.r"
#include "SysTypes.r"
#include "kchr.r"
include "traps";  

/* Startup resource. */
type 'STRT'
	{ 
	cstring[32];      /* Mcr name. */
	cstring[32];      /* Mcr volume. */
	cstring[32];      /* Load name. */
	cstring[32];      /* Load volume. */
	cstring[32];      /* Host Name. */
	cstring[32];      /* Default device. */
	longint;          /* Boot slot for machines with old roms and without 32bit QuickDraw. */
	longint;          /* BitArray Heap. */
	longint;          /* misc heap. */
	};

resource 'STRT' (0) 
{
	"m139.mcr",
	"hd",
	"lod1.load",
	"hd",
	"p1",
	"hd",
	12,
	0x8895e,
	0xbb63a
};

/* These define's are used in the MENU resources to disable specific menu items. */
#define AllItems	0b1111111111111111111111111111111	/* 31 flags */
#define MenuItem1	0b00001
#define MenuItem2	0b00010
#define MenuItem3	0b00100
#define MenuItem4	0b01000
#define MenuItem5	0b10000


resource 'SIZE' (-1) {
		dontSaveScreen, 				/* Save screen			*/
		acceptSuspendResumeEvents,		/* suspend-resume		*/
		enableOptionSwitch,				/* Options switch		*/
		canBackground,					/* accept Juggler background	*/
		multiFinderAware,				/* Juggler aware		*/
		backgroundAndForeground,		
		dontGetFrontClicks,				/* ignore user 'bring to front' clicks */
		ignoreChildDiedEvents,			/* used by debuggers	*/
		not32BitCompatible,				/* maybe in 7.0			 */
		reserved,
		reserved,
		reserved,
		reserved,
		reserved,
		reserved,
		reserved,
		1331200,						/* size 				*/
		 870400							/* min size      		*/
};

resource 'DLOG' (128, "About microExplorer") {
	{66, 102, 300, 400},							/* ab 11/7/88 */
	dBoxProc, visible, noGoAway, 0x0,128, ""
};

resource 'DITL' (128, purgeable) {
	{	/* array DITLarray: 9 elements */
		/* [1] */
		{188, 110, 208, 189},
		Button {
			enabled,
			"Continue"
		},
		/* [2] */
		{75, 167, 91, 259},
		StaticText {
			disabled,
			""
		},
		/* [3] */
		{8, 26, 26, 274},
		StaticText {
			disabled,
			"microExplorer for the Macintosh II"
		},
		/* [4] */
		{32, 80, 50, 212},
		StaticText {
			disabled,
			"------------------"
		},
		/* [5] */
		{141, 23, 159, 275},
		StaticText {
			disabled,
			"Copyright  1988 Texas Instruments."
		},
		/* [6] */
		{75, 65, 90, 166},
		StaticText {
			disabled,
			"Creation Date:"
		},
		/* [7] */
		{102, 131, 131, 163},
		Icon {
			disabled,
			128
		},
		/* [8] */
		{160, 79, 176, 217},
		StaticText {
			disabled,
			"All Rights Reserved."
		},
		/* [9] */
		{50, 101, 67, 246},           /* ab 11/7/88 */
		StaticText {
			disabled,
			"Version 6.09"
		}
	}
};

/* ab 11/7/88 */
resource 'DLOG' (180, "Quit microExplorer") {
	{50, 50, 210, 295},							
	dBoxProc, visible, noGoAway, 0x0, 180, "" 
};

data 'mstr' (101) {
	$"1251 7569 7420 6D69 6372 6F45 7870 6C6F"        /* .Quit microExplo */
	$"7265 72"                                        /* rer */
};

/* ab 11/7/88 */
resource 'DITL' (180, purgeable) {
	{
		/* [1] */
		{0x85, 0x84, 0x99, 0xc0},
		Button {
			enabled,
			"OK"
		}, 
		/* [2] */
		{0x84, 0x28, 0x98, 0x64},
		Button {
			enabled,
			"Cancel"
		},
		/* [3] */
		{0x0A, 0x51, 0x3C, 0xE4},
		StaticText {
			disabled,
			"Quitting will discard the microExplorer environment."
		},
		/* [4] */
		{0x53, 0x1D, 0x77, 0xCF},
		StaticText {
			disabled,
			"Do you really want to quit microExplorer?"
		},
		/* [5] */
		{0x10, 0x13, 0x37, 0x3E},
		Icon {					/* The open hand icon */
			disabled,
			0
		}
	}
};


	/* TI Bug icon for About microExplorer */
resource 'ICON' (128) {
		$"0000 0000 007F 0000 007F 0000 007F 0000"
		$"007F 0000 007F 0000 007F 0C00 007F 1E00"
		$"007F CCF0 007F C1F8 007F DDF8 007F DDF8"
		$"007E 1C38 7FFC 1C78 7FFC 187C 3FFF BBFE"
		$"1FFF BBFE 0FFF BBFE 07FF 3BFE 03FF 33FE"
		$"03E7 77FE 01C3 00FC 0003 01F0 0003 83C0"
		$"0003 FF80 0001 FF00 0001 FE00 0000 FE00"
		$"0000 7E00 0000 3F00 0000 0F"
} ;


resource 'MENU' (128, "Apple", preload) {
	128, textMenuProc,
	AllItems & ~MenuItem2,	/* Disable item #2 */
	enabled, apple,
	{
		"About microExplorer",
			noicon, nokey, nomark, plain;
		"-", 
			noicon, nokey, nomark, plain
	}
};

resource 'MENU' (129, "File", preload) {
	129, textMenuProc,
	AllItems & ~MenuItem2,	/* Disable item #2 */
	enabled, "File",
	{
		"Printer Setup",                        /* ab 11/15/88 */
			noicon, noKey, nomark, plain;
		"-",
			noicon, nokey, nomark, plain;
		"Quit microExplorer",
			noicon, noKey, nomark, plain
	}
};

resource 'MENU' (130, "Edit", preload) {
	130, textMenuProc,
	0,	/* Disable all items */
	enabled, "Edit",
	 {
		"Undo",
			noicon, noKey, nomark, plain;
		"-",
			noicon, nokey, nomark, plain;
		"Cut",
			noicon, noKey, nomark, plain;
		"Copy",
			noicon, nokey, nomark, plain;
		"Paste",
			noicon, nokey, nomark, plain;
		"Clear",
			noicon, nokey, nomark, plain
	}
};


resource 'MENU' (133, "Special", preload) {
	133, textMenuProc,
	allEnabled, 
	enabled, "Special",
	 {
		"Warm Boot",
			noicon, nokey, nomark, plain;
		"Force Crash",
			noicon, nokey, nomark, plain
	}
};

resource 'MENU' (134, "Options", preload) {
	134, textMenuProc,
	AllItems & ~MenuItem3,	/* Disable item #3 */
    enabled, "Options",
	{
		"Set Boot",
			noicon, nokey, nomark, plain;
		"Set Screen Size",
			noicon, nokey, nomark, plain;
		"-",								/* ab 11/7/88 */
			noicon, nokey, nomark, plain;
		"Enable Direct Drawing",
			noicon, nokey, check, plain;
		"Enable Debug Trace",
			noicon, nokey, nomark, plain
	}
};

/* ab 11/7/88 */ 
resource 'vers' (2) {
	0x02, 0x08, release, 0, verUS,
	"6.09",
	"Driver Version 6.09"
};

type 'TIMX' as 'STR ';		/* ab 11/7/88 */

resource 'TIMX' (0) {						/* ab 11/7/88 */
	"Texas Instruments microExplorer  " 
	"Driver Version 6.09              "
};

#ifdef TRASH
data 'ICN#' (128) { /* guy with wires comming out of head and better mask*/
	$"0000 0060 0000 0080 0000 0100 0000 0200"
	$"0000 0278 0000 0280 1FFF FF38 0000 0240"
	$"1FFF FF98 0000 0420 1FFF FFD0 0000 0824"
	$"1FFF FFC8 0000 2010 1FFF FFE0 0000 8000"
	$"0000 4000 0000 2000 0000 1000 0000 1000"
	$"0000 0800 0000 0800 0000 1000 0000 1000"
	$"0000 1000 0000 0C00 0000 03E0 0000 0010"
	$"0000 0010 0000 0008 0000 0000 0000 0000"
	$"0000 007C 0000 00FC 0000 01FC 0000 03FC"
	$"0000 03FC 0000 03FC 1FFF FFFC 1FFF FFFC"
	$"1FFF FFFC 1FFF FFFC 1FFF FFFC 1FFF FFFC"
	$"1FFF FFFC 1FFF FFFC 1FFF FFFC 0000 FFFC"
	$"0000 7FFC 0000 3FFC 0000 1FFC 0000 1FFC"
	$"0000 0FFC 0000 0FFC 0000 1FFC 0000 1FFC"
	$"0000 1FFC 0000 0FFC 0000 03FC 0000 001C"
	$"0000 001C 0000 000C 0000 0000 0000 0000"
};
#endif

data 'ICN#' (128) { /* TI Bug ICON....Keith 1/27/88 */
	$"0000 0000 007F 0000 007F 0000 007F 0000" 
	$"007F 0000 007F 0000 007F 0C00 007F 1E00" 
	$"007F CCF0 007F C1F8 007F DDF8 007F DDF8" 
	$"007E 1C38 7FFC 1C78 7FFC 187C 3FFF BBFE" 
	$"1FFF BBFE 0FFF BBFE 07FF 3BFE 03FF 33FE" 
	$"03E7 77FE 01C3 00FC 0003 01F0 0003 83C0" 
	$"0003 FF80 0001 FF00 0001 FE00 0000 FE00" 
	$"0000 7E00 0000 3F00 0000 0F00 0000 0000" 
	$"00FF 8000 00FF 8000 00FF 8000 00FF 8000" 
	$"00FF 8000 00FF 8C00 00FF 9E00 00FF FFF0" 
	$"00FF EFF8 00FF FFFC 00FF FFFC 00FF FFFC" 
	$"FFFF FFFC FFFE 1CFC FFFF FFFE 7FFF FFFF" 
	$"3FFF FFFF 1FFF FFFF 0FFF BFFF 07FF BFFF" 
	$"07FF FFFF 03E7 8FFE 01C7 83FC 0007 FFF0" 
	$"0007 FFC0 0003 FF80 0003 FF00 0001 FF00" 
	$"0000 FF00 0000 7F80 0000 3F80 0000 0F00" 
};

resource 'BNDL' (128) {
	'TIMX',                  /* ab 11/7/88 */
	0,
	{
		'ICN#',
		{
			0, 128
		},
		'FREF',
		{
			0, 128
		}
	}
};


resource 'FREF' (128) {
	'APPL',
	0,
	""
};

resource 'ALRT' (100, purgeable) {
	{100, 120, 186, 392},
	100,
	{	/* array: 4 elements */
		/* [1] */
		OK, visible, sound1,
		/* [2] */
		OK, visible, sound1,
		/* [3] */
		OK, visible, sound1,
		/* [4] */
		OK, visible, sound1
	}
};

resource 'DITL' (100, purgeable) {
	{
		/* [1] */
		{56, 10, 76, 62},
		Button {
			enabled,
			"OK"
		},
		/* [2] */
		{8, 72, 88, 270},
		StaticText {
			disabled,
			"^0"
		},
		/* [3] */
		{68, 72, 86, 270},
		StaticText {
			disabled,
			"^1"
		}

	}
};

resource 'STR ' (200) {
	"The microExplorer is not installed."
};

resource 'STR ' (201) {
	"The microExplorer Load partition-file or Microcode partition-file "
	"is Missing.  Boot Failed."
};

resource 'STR ' (202) {   /* unused */
	"The microExplorer failed the power-up test."
};

resource 'STR ' (203) {
	"The microExplorer Microcode partition-file did not load properly."
};

resource 'STR ' (204) {
	"microExplorer application open failed."
};

resource 'STR ' (205) {
	"microExplorer application initialization failed."
};

resource 'STR ' (206) {
	"MultiFinder not found.  The microExplorer requires that "
	"MultiFinder is installed and active before it will boot."
};

resource 'STR ' (207) {
	"Unable to write/read memory on microExplorer board."
};

resource 'STR ' (208) {
	"microExplorer board SelfTestErr ="
};

resource 'STR ' (209) {
 	"Boot of microcode timed out."
};

resource 'STR ' (210) {
 	"Boot of microcode failed."
};

resource 'STR ' (211) {
 	"BitArrayPool allocation failed."
};

resource 'STR ' (212) {
	"Memory allocation failed in TV initializations."
};

resource 'STR ' (213) {
	"Memory allocation failed in Disk initializations."
};

resource 'STR ' (214) {
	"return_acb_fast: Can't find acb queue"
};

resource 'STR ' (215) {
	"Memory allocation failure."
};

resource 'STR ' (216) {
	"microExplorer reset timed out."
};

resource 'STR ' (217) {
	"microExplorer keyboard resource not found."
};

resource 'STR ' (218) {
	"System keyboard resource not restored."
};

resource 'STR ' (219) {
	"SYNC timed out, status ="
};

resource 'STR ' (220) {
	"microExplorer reset error ="
};

resource 'STR ' (221) {
	"Error opening MCR file ="
};

resource 'STR ' (222) {
	"Error reading MCR file ="
};

resource 'STR ' (223) {
	"Start address looks bad ="
};

resource 'STR ' (224) {
	"Error on PBHOpen"
};

resource 'STR ' (225) {
	"Error on PBRead"
};

resource 'STR ' (226) {
	"Load Band Write Protected"
};

resource 'STR ' (227) {
	"Error on PBWrite"
};

resource 'STR ' (228) {
	"Bitarray Pool too small for initial ^0-pixel screen"
};

resource 'STR ' (229) {
	"Too many Mac-resident bit arrays"
};


resource 'ALRT' (128) {
	{28, 138, 208, 378},
	910,
	{	/* array: 4 elements */
		/* [1] */
		OK, visible, sound1;
		/* [2] */
		OK, visible, sound1;
		/* [3] */
		OK, visible, sound1;
		/* [4] */
		OK, visible, sound1
	}
};

resource 'DITL' (910) {
	{	/* array DITLarray: 3 elements */
		/* [1] */
		{126, 150, 146, 238},
		Button {
			enabled,
			"Continue"
		},
		/* [2] */
		{54, 8, 71, 232},
		StaticText {
			disabled,
			"^0"
		},
		/* [3] */
		{78, 8, 96, 232},
		StaticText {
			disabled,
			"^1"
		}
	}
};

#ifdef TRASH
resource 'DITL' (910) {
	{	/* array DITLarray: 3 elements */
		/* [1] */
		{126, 150, 146, 213},
		Button {
			enabled,
			"Continue"
		};
		/* [2] */
		{49, 11, 66, 207},
		StaticText {
			disabled,
			"^0"
		};
		/* [3] */
		{68, 52, 88, 130},
		StaticText {
			disabled,
			"^1"
		}
	}	
};
#endif

resource 'CURS' (22) {    /* Northwest arrow */
	$"0000 4000 6000 7000 7800 7C00 7E00 7F00"
	$"7800 6C00 4C00 0600 0600 0300 03",
	$"C000 E000 F000 F800 FC00 FE00 FF00 FF80"
	$"FFC0 FC00 FE00 CF00 8F00 0780 0780 0380",
	{1, 0}
};

resource 'CURS' (41) {	/*  Northeast arrow */
	$"0000 0010 0030 0070 00F0 01F0 03F0 07F0"
	$"00F0 01B0 0190 0300 0300 0600 06",
	$"0018 0038 0078 00F8 01F8 03F8 07F8 0FF8"
	$"0FF8 03F8 03F8 0798 0780 0F00 0F00 0E",
	{1, 10}
};

resource 'CURS' (36) {  /* Circle Plus */
	$"0000 0000 0780 1FE0 3B70 3330 6318 7FF8"
	$"7FF8 6318 3330 3B70 1FE0 0780",
	$"0000 0FC0 17A0 3FF0 7B78 F33C E31C FFFC"
	$"FFFC E31C F33C 7B78 3FF0 17A0 0FC0",
	{8, 7}
};

/*   Not used  
resource 'CURS' (100) {	 THin Circle Plus 
	$"0000 0000 07C0 0920 1110 2108 2108 3FF8"
	$"2108 2108 1110 0920 07C0",
	$"0000 07C0 0FE0 1930 3398 638C 6FEC 7FFC"
	$"6FEC 638C 3398 1930 0FE0 07C0",
	{7, 6}
};  not used  */

resource 'CURS' (33) {	/*  Upper left Corner  */
	$"0000 7FE0 7FE0 6000 6000 6000 6000 6000"
	$"6000 6000 60",
	$"FFF0 FFF0 FFF0 FFF0 F000 F000 F000 F000"
	$"F000 F000 F000 F0",
	{2, 1}
};

resource 'CURS' (34) {	/*  Lower Right Corner  */
	$"0000 0000 0030 0030 0030 0030 0030 0030"
	$"0030 0030 1FF0 1FF0",
	$"0000 0078 0078 0078 0078 0078 0078 0078"
	$"0078 3FF8 3FF8 3FF8 3FF8",
	{10, 9}
};

resource 'CURS' (112) {	/* Small Dot */
	$"0000 0000 0000 0000 0000 0300 03",
	$"0000 0000 0000 0000 0380 0780 0780 07",
	{5, 5}
};

resource 'CURS' (78) {	/* Thin hollow plus */
	$"0000 0100 0100 0100 0100 0100 3FF8 0100"
	$"0100 0100 0100 01",
	$"0000 0300 0300 0300 0300 0300 7FF8 7FF8"
	$"0300 0300 0300 0300 03",
	{6, 7}
};


resource 'CURS' (24) {  /* Thick Up Arrow */
	$"0000 0100 0380 07C0 0FE0 1FF0 07C0 07C0"
	$"07C0 07C0 07C0 07C0",
	$"0100 0380 07C0 0FE0 1FF0 3FF8 3FF8 0FE0"
	$"0FE0 0FE0 0FE0 0FE0 0FE0",
	{1, 7}
};

resource 'CURS' (26) {  /* Thick Down Arrow */
	$"0000 07C0 07C0 07C0 07C0 07C0 07C0 1FF0"
	$"0FE0 07C0 0380 01",
	$"0FE0 0FE0 0FE0 0FE0 0FE0 0FE0 3FF8 3FF8"
	$"1FF0 0FE0 07C0 0380 01",
	{11, 7}
};

resource 'CURS' (113) {  /* Thick Cross */
	$"0000 0000 3006 180C 0C18 0630 0360 01C0"
	$"01C0 0360 0630 0C18 180C 3006",
	$"0000 0000 700E 381C 1C38 0E70 07E0 03C0"
	$"03C0 07E0 0E70 1C38 381C 700E",
	{7, 8}
};

resource 'CURS' (28) {  /* Thick Up-Down Arrow */
	$"0000 0100 0380 07C0 0FE0 1FF0 07C0 07C0"
	$"07C0 07C0 1FF0 0FE0 07C0 0380 01",
	$"0100 0380 07C0 0FE0 1FF0 3FF8 3FF8 0FE0"
	$"0FE0 3FF8 3FF8 1FF0 0FE0 07C0 0380 01",
	{1, 7}
};

resource 'CURS' (40) {  /* Blank cursor */
	$"",
	$"",
	{2, 7}
};

resource 'DLOG' (160, "Select Screen Size", purgeable) {
	{102, 134, 284, 448},
	rDocProc,
	invisible,
	noGoAway,
	0x0,
	7630,
	"Set Screen Size"
};

resource 'DITL' (7630) {
	{	/* array DITLarray: 14 elements */
		/* [1] */
		{150, 209, 170, 269},
		Button {
			enabled,
			"OK"
		},
		/* [2] */
		{150, 110, 170, 170},
		Button {
			enabled,
			"Cancel"
		},
		/* [3] */
		{89, 7, 105, 55},
		StaticText {
			disabled,
			"Width:"
		},
		/* [4] */
		{89, 128, 105, 184},
		StaticText {
			disabled,
			"Height: "
		},
		/* [5] */
		{89, 56, 105, 116},
		EditText {
			enabled,
			""
		},
		/* [6] */
		{89, 180, 105, 240},
		EditText {
			enabled,
			""
		},
		/* [7] */
		{8, 16, 24, 96},
		RadioButton {
			enabled,
			"640x480"
		},
		/* [8] */
		{32, 16, 48, 104},
		RadioButton {
			enabled,
			"1024x480"
		},
		/* [9] */
		{56, 16, 72, 104},
		RadioButton {
			enabled,
			"1024x768"
		},
		/* [10] */
		{8, 160, 24, 248},
		RadioButton {
			enabled,
			"1024x768"
		},
		/* [11] */
		{32, 160, 48, 248},
		RadioButton {
			enabled,
			"1024x768"
		},
		/* [12] */
		{56, 160, 72, 248},
		RadioButton {
			enabled,
			"1024x768"
		},
		/* [13] */
		{119, 7, 136, 273},
		StaticText {
			disabled,
			"Number of Mouse Documentation Lines:"
		},
		/* [14] */
		{119, 273, 135, 304},
		EditText {
			enabled,
			""
		}
	}
};


resource 'DITL' (150) {
	{	/* array DITLarray: 18 elements */
		/* [1] */
		{224, 320, 244, 399},
		Button {
			enabled,
			"OK"
		},
		/* [2] */
		{224, 64, 244, 143},
		Button {
			enabled,
			"Abort"
		},
		/* [3] */
		{16, 8, 32, 104},
		StaticText {
			disabled,
			"Load Volume:"
		},
		/* [4] */
		{16, 120, 32, 392},
		EditText {
			enabled,
			""
		},
		/* [5] */
		{40, 8, 56, 115},
		StaticText {
			disabled,
			"Load Name: "
		},
		/* [6] */
		{88, 8, 104, 115},
		StaticText {
			disabled,
			"MCR Name: "
		},
		/* [7] */
		{64, 8, 80, 115},
		StaticText {
			disabled,
			"MCR Volume: "
		},
		/* [8] */
		{112, 8, 128, 115},
		StaticText {
			disabled,
			"Host Name: "
		},
		/* [9] */
		{136, 8, 152, 115},
		StaticText {
			disabled,
			"Default Device: "
		},
		/* [10] */
		{40, 120, 56, 392},
		EditText {
			enabled,
			""
		},
		/* [11] */
		{64, 120, 80, 392},
		EditText {
			enabled,
			""
		},
		/* [12] */
		{88, 120, 104, 392},
		EditText {
			enabled,
			""
		},
		/* [13] */
		{112, 120, 128, 392},
		EditText {
			enabled,
			""
		},
		/* [14] */
		{136, 120, 152, 392},
		EditText {
			enabled,
			""
		},
		/* [15] */
		{160, 8, 176, 115},
		StaticText {
			disabled,
			"Nubus Slot:"
		},
		/* [16] */
		{160, 120, 176, 140},
		EditText {
			enabled,
			""
		},
		/* [17] */
		{184, 8, 200, 115},
		StaticText {
			enabled,
			"Misc Heap Size: "
		},
		/* [18] */
		{184, 120, 200, 192},
		EditText {
			enabled,
			""
		}
	}
};

resource 'DLOG' (150, "Set Boot", purgeable) {
	{112, 108, 392, 570},
	rDocProc,
	visible,
	noGoAway,
	0x0,
	150,
	"Set Boot Parameters"
};


/* MouseFont */

data 'FONT' (25728, "MouseFont") {
};

resource 'FONT' (25744) {
	doExpandFont,
	proportionalFont,
	blackFont,
	notSynthetic,
	nofctbRsrc,
	oneBit,
	noCharWidthTable,
	noImageHeightTable,
	0,
	255,
	20,
	0,
	0,
	17,
	16,
	16,
	0,
	0,
	83,
	$"07 E1 FF FF FF FF E0 F8 01 F0 60 03 FF E7 00 00"
	$"60 07 C0 3E 00 00 00 00 00 70 00 E0 7F FF C0 00"
	$"08 00 00 08 00 00 00 00 00 00 00 18 00 60 00 03"
	$"00 80 02 00 00 02 02 48 0F 00 07 C0 60 00 01 80"
	$"3C 00 F8 01 FF 00 3F E0 03 00 07 C0 60 00 01 80"
	$"30 00 F8 01 FE 00 1F E0 0F C0 0F 80 00 00 00 07"
	$"E0 0F 80 07 FC 0F F8 30 06 00 03 80 1C 00 E0 07"
	$"01 FF E0 00 00 07 FF F0 87 FF FE 00 18 00 00 40"
	$"00 20 00 00 08 01 00 00 18 00 00 18 00 07 F8 FF"
	$"F8 06 20 03 00 07 FF 80 80 00 00 20 00 01 FF FE"
	$"00 00 00 00 03 E1 07 E1 FF FF FF FF E3 FE 07 FC"
	$"70 07 FF EC 80 00 90 1F F0 FF 80 00 00 00 00 F8"
	$"01 F0 41 41 E0 00 1C 00 00 18 00 00 F0 00 07 FF"
	$"F8 24 00 F0 00 07 00 40 04 00 00 02 00 00 10 C0"
	$"70 70 70 00 03 80 C2 03 83 83 E0 C0 C1 F0 04 00"
	$"70 70 70 00 03 80 08 03 83 83 E3 00 31 F0 00 61"
	$"C3 80 C0 00 0C 0C 00 0E 1C 1F 03 30 3E 38 0E 18"
	$"0F E0 7F 03 F8 1F C3 00 30 00 00 07 FF F1 C7 FF"
	$"FE 00 18 10 00 E0 00 38 00 00 0C 03 80 80 18 02"
	$"00 3C 00 07 F8 80 08 06 30 03 07 FF FF 81 80 00"
	$"E0 70 10 21 FF FE 10 00 00 20 02 00 07 E1 FE 00"
	$"3F FF E7 07 0F FE 38 0E C0 6A 40 01 08 38 39 FF"
	$"C0 00 00 00 00 D8 01 F0 41 41 70 00 3E 70 00 38"
	$"00 03 F0 00 07 FF F8 42 01 F8 00 0E 7E 20 08 38"
	$"70 02 00 00 00 20 17 F8 70 00 03 81 00 07 FA 03"
	$"F0 21 03 F0 04 00 17 F8 70 00 03 80 08 07 FA 03"
	$"F1 00 23 F0 00 20 43 C0 E0 00 1C 08 00 1E 10 7F"
	$"C1 E0 FF 9C 1C 7E 1F F0 E3 87 1C 38 E4 E1 C8 00"
	$"00 00 08 03 E7 FF FE 00 18 30 01 F0 3C 3E 00 40"
	$"0C 03 41 00 18 03 00 7E 00 07 F8 E0 38 06 38 3B"
	$"78 2E 00 03 87 80 E0 F8 30 31 FF FE 30 00 00 30"
	$"03 FF 07 E1 FE 00 3F FF EE 03 9F FF 1C 1C FB E9"
	$"A0 02 04 70 1F FF E0 00 00 00 01 8C 03 F8 42 21"
	$"38 30 7F 70 00 7F 00 07 F8 88 8E 00 18 81 03 FC"
	$"00 1C 81 10 10 7F F8 02 02 48 00 10 1F F8 58 00"
	$"06 82 00 07 FE 07 F8 12 07 F8 06 00 1F F8 58 00"
	$"06 80 18 07 FE 07 F8 80 47 F8 C0 10 5F C0 9E 01"
	$"E4 10 06 1F D0 7F E0 C1 FF 8E 38 FF 3F F9 80 CC"
	$"06 60 34 33 08 1C 01 C0 1C 07 F7 FF FE 7F 98 70"
	$"03 F8 FF 3F 80 70 0E 07 22 00 18 03 80 FF 00 07"
	$"F8 78 F0 06 3C 2B 58 2E 00 07 9F E0 E1 FC 70 39"
	$"FF FE 70 00 00 38 00 01 07 00 3E 00 3F FF EC 01"
	$"9F FF 0E 38 FB E4 10 04 02 20 09 FF C1 C0 00 00"
	$"01 8C 03 F8 42 21 1C 70 FF F0 00 FF C0 0F 08 88"
	$"8E 00 19 00 87 FE 00 38 01 08 20 C7 8C 02 00 00"
	$"00 17 FF FA 78 00 07 92 00 07 FF FD FC 12 0F E8"
	$"01 C7 FF FA 78 00 07 90 E0 07 FF FD FC 80 4F E9"
	$"E0 10 7F E8 FF 03 FC 50 0F 3F F0 7F F0 C3 FF 87"
	$"70 FF 3F F9 80 CC 06 62 34 00 08 1C 01 C0 3E 0F"
	$"FF FF FE 3F 18 FF FF FD C3 BF E0 7C 07 0E 14 00"
	$"1F FF C1 FF 90 07 F8 3D E0 06 3E 1B 68 2E 00 0F"
	$"BB 70 E3 FE FF FD FC FE FF FF FF FC 03 FF 27 80"
	$"7E 00 3F FF F8 00 FF FF 87 70 FB E2 08 08 61 00"
	$"00 FF 83 E0 60 78 03 06 07 FC 44 11 0E E0 1C 70"
	$"00 7F F0 0E 0A AA AE 00 1A 18 4F FF 00 70 01 04"
	$"40 DC EC 02 00 00 00 0F 7F FA 70 00 03 94 00 07"
	$"FF BD FC 0C 0F E8 00 37 7F FA 70 00 03 93 00 07"
	$"FF BD FC 8C 4F E9 E7 1F FF E8 EF 03 DC 51 CF 3F"
	$"FF CF F0 C3 FC 83 E1 FF FF FF 00 78 03 C2 1C 73"
	$"88 1C 01 C0 7F 01 C7 FF FE 1E 19 FF F8 E1 C3 BF"
	$"F8 7F 03 9C 08 00 1F FF E3 FF DC 07 F8 1F C0 06"
	$"3F 33 37 EE 00 1F B3 30 E0 71 FF FF FC FF FF FF"
	$"FF FE 03 60 77 80 7E 08 3F EF F8 20 FF BF 83 60"
	$"FB E1 04 1E F7 81 00 77 07 60 E1 FE 03 26 07 BC"
	$"44 11 06 C0 1C 38 10 38 F8 1C 0A AA AE 00 1F BD"
	$"FF FF 80 60 02 02 81 F8 7E 02 02 48 00 0B FF EB"
	$"F8 12 07 F4 00 05 FF F5 FC 0C 0F E8 00 1B FF EB"
	$"F8 00 07 F6 00 05 FF F5 FC 4C 8F E9 CF 9D FF EF"
	$"E6 01 9F D3 E7 3F FD CF F0 C3 FC C1 C1 FF FF FF"
	$"00 79 F3 CF 9A 33 10 1C 01 C0 FF 81 C6 00 1E 0C"
	$"1B FF F8 E3 66 FF FE 7F C3 9C 14 00 1F FF F7 FF"
	$"FF 07 F8 0F 80 00 3F A3 10 2E 00 3F E3 18 E0 70"
	$"FF FD F8 7E FF FF FF FC 03 E0 FF C0 FE 1C 3F C7"
	$"F8 70 FF 1F 80 00 FB E0 82 03 FC 03 80 22 0E 01"
	$"C7 FF 86 73 0F 1E 48 09 00 00 1C 3C 18 18 3C 1C"
	$"0F FF FE 33 18 FF 03 FC 00 80 0C 00 01 E0 1F FD"
	$"FC 00 07 88 DF C8 F8 0C 07 C4 78 04 FE C5 FC 0C"
	$"0F E8 07 88 DF C8 F8 00 07 C4 78 04 FE C5 FC 73"
	$"8F E9 9F D5 FF A1 F0 00 3E 17 F3 2F FD 0F E0 C1"
	$"FC 03 E0 FF 7F FF 00 78 03 C2 1E 00 18 1C 01 C0"
	$"1C 01 C6 00 1E 00 1F FF F8 E3 3C FF FF FF F1 98"
	$"22 00 1F FF F8 FF 1F C7 F8 07 00 3F FC 33 30 2E"
	$"00 07 FF F8 E0 70 70 39 F8 7E 70 00 00 39 F1 03"
	$"77 E1 FE 08 3F EF F8 20 FF BF 83 60 FB E1 C1 03"
	$"FC 01 00 14 1C 1B 9F FF E6 23 0F BE 70 07 06 C0"
	$"38 1F 1C 08 1C 38 0F FF FE 73 98 87 02 1C 03 00"
	$"10 02 80 60 18 02 00 00 DF C8 07 8D FC 0C 0F EC"
	$"FE C4 78 00 F8 0C 07 C0 DF C8 07 8D FC 73 8F EC"
	$"FE C4 78 00 F8 00 07 C2 FF D3 3F A3 F8 30 7F 17"
	$"FE AF E6 07 C0 00 F8 07 70 FF 3F F9 80 CC 06 62"
	$"35 80 68 1C 01 C0 1C 01 C6 00 1E 00 1F FF F8 E3"
	$"3C FF FE 7F C1 98 41 00 1F FF F8 FF 1F 3F FF 0F"
	$"80 3F F6 1B 60 2E 00 0D FF F8 E0 70 30 31 F0 3E"
	$"30 00 00 31 12 00 27 E1 FE 00 3F FF F8 00 FF FF"
	$"87 70 FB E2 20 87 FE 00 00 08 18 1F 07 FF 8C 01"
	$"9F FF 70 07 0E E0 38 0F FE 00 0E 38 0A AA AE E1"
	$"D9 93 82 4C 07 00 10 04 40 70 38 02 02 4B FF E8"
	$"00 0D FC 0C 0F ED FF F4 00 03 F8 12 07 F3 FF E8"
	$"00 1D FC 4C 8F ED FF F6 00 03 F8 00 07 F6 FF F3"
	$"9F 33 FC 30 FF 3F FE E7 CE 3F 98 06 7F 0E 38 7E"
	$"3F F9 80 CC 06 60 34 61 88 FF 8F F8 1C 01 C6 0C"
	$"1E 00 1B FF F8 E3 66 FF F8 7F 00 60 80 80 1F FF"
	$"F0 FF 1C 1F FE 1A C0 00 26 0F C0 2E 00 0C E3 18"
	$"E0 70 10 21 E0 1E 10 00 00 21 10 00 07 F3 FE 00"
	$"3F FF EC 01 9F FF 0E 38 FB E2 10 4F FF 00 00 00"
	$"00 0E 01 FE 0C 01 9F FF 48 09 1C 70 70 03 FF 00"
	$"0E 38 0A AA AF C0 FB 99 C2 64 0E 00 10 08 20 3F"
	$"E0 02 00 07 7F F8 00 0D FC 0C 0F EF FF BC 00 02"
	$"70 00 03 97 7F F8 00 35 FC 8C 4F EF FF BB 00 02"
	$"70 00 03 97 FF F3 CE 33 FC 30 FF 3F FF E3 9E 23"
	$"BC 0F 71 1C 1C 18 1F F0 E3 87 1C 38 E3 7F B0 7F"
	$"07 F0 1C 01 C6 1E 1F FF F9 FF F8 E1 C3 BF E0 7C"
	$"00 60 00 7F FF FF E0 FF 10 0F FC 32 60 3F C3 03"
	$"00 2E 00 18 33 37 FF FE 00 01 E0 1E 00 00 00 01"
	$"10 00 07 F3 FE 00 3F FF EE 03 9F FF 1C 1C FB EE"
	$"08 3F FF 80 00 00 00 00 00 78 18 00 FF FF C8 09"
	$"38 30 F0 00 FE 00 0F FF 08 88 8F C0 FF 99 E2 64"
	$"1C 00 10 10 10 0F C0 02 00 07 FF F8 00 15 FC 12"
	$"0F EF FF FA 00 02 78 00 07 97 FF F8 01 C5 FC 80"
	$"4F EF FF F8 E0 02 78 00 07 90 3F F3 C0 3F FC 30"
	$"FF FF F8 20 1E 23 FC 0F F1 38 0E 00 0F E0 7F 03"
	$"F8 1F C1 12 20 3E 03 E0 1C 00 06 3F 1F FF F8 FF"
	$"F8 E1 C3 BF 80 70 07 FE 00 7F FF FF C0 FF 00 07"
	$"F8 67 30 3F C3 03 00 2E 00 18 3B 73 F9 FC 00 01"
	$"C0 0E 00 00 00 01 10 00 07 FF FE 00 3F FF E7 07"
	$"0F FE 38 0E FB F1 04 03 FC 00 00 00 00 00 00 00"
	$"1F FF FF FF C8 09 70 0F E0 00 1C 00 0E FE 08 88"
	$"88 00 00 99 02 64 38 00 00 20 08 00 00 02 02 48"
	$"1F F8 00 17 F8 12 07 FF FE 02 00 00 58 00 06 80"
	$"1F F8 06 07 F8 80 47 FF FE 00 18 00 58 00 06 80"
	$"2F E1 80 3F F8 30 7F EF E8 20 0C 02 78 07 90 30"
	$"06 00 03 80 1C 00 E0 07 02 D2 D0 1C 01 C0 1C 00"
	$"06 7F 9F FF F8 70 00 E0 FF 3E 00 40 04 92 00 00"
	$"00 03 80 FF 00 03 F0 CF 98 7F 81 83 00 28 00 30"
	$"1F E1 F0 F8 00 01 F8 7E 00 00 00 01 13 FF 07 FF"
	$"FF FF FF FF E3 FE 07 FC 70 07 FB F0 82 03 FC 00"
	$"00 00 00 00 00 00 1F FF FF FF C8 09 E0 0F C0 00"
	$"18 00 00 7C 00 00 00 00 00 93 02 4C 70 00 10 40"
	$"04 00 00 02 00 00 17 F8 00 23 F0 21 03 F7 FA 01"
	$"00 00 70 00 03 80 17 F8 04 03 F1 00 23 F7 FA 00"
	$"08 00 70 00 03 80 21 E0 00 5F F0 78 3F EF 08 10"
	$"00 03 80 00 70 00 00 00 00 00 00 00 00 00 02 52"
	$"90 08 00 80 00 00 06 00 1F FF F8 30 00 E0 3C 38"
	$"00 00 04 92 00 00 00 03 00 FF 00 01 E0 9F C8 FF"
	$"01 83 01 F8 00 30 07 80 E0 70 00 01 F8 7E 00 00"
	$"00 01 10 00 07 FF FF FF FF FF E0 F8 01 F0 60 03"
	$"FF F0 41 03 FC 00 00 00 00 00 00 00 00 00 00 00"
	$"48 09 C0 0F 00 00 10 00 00 38 00 00 00 00 00 87"
	$"02 1C 60 00 00 80 02 00 00 02 00 00 70 70 10 C3"
	$"E0 C0 C1 F3 83 80 C2 00 70 00 03 80 70 70 04 03"
	$"E3 00 31 F3 83 80 08 00 70 00 03 80 E1 C0 00 C7"
	$"C0 CC 0F 87 0E 18 00 03 00 00 30 00 00 00 00 00"
	$"00 00 00 00 02 3F 17 FF F0 00 00 00 06 00 1F FF"
	$"F8 10 00 E0 00 20 00 00 05 0A 00 00 00 02 00 FF"
	$"00 00 C0 FF F9 FE 00 C3 00 00 00 60 00 00 40 20"
	$"00 01 F8 7E 00 00 00 01 13 FF 07 FF F8 00 00 00"
	$"00 00 00 00 00 00 FF E8 20 83 FC 00 00 00 00 00"
	$"00 00 00 00 00 00 7F FF 00 00 00 00 00 00 00 10"
	$"00 00 00 00 00 FF 03 FC 00 00 00 00 00 00 00 00"
	$"00 00 07 C0 0F 01 FF 00 3F E0 F8 00 3C 00 60 00"
	$"01 80 07 C0 03 01 FE 00 1F E0 F8 00 30 00 60 00"
	$"01 80 07 C0 1F 81 FF 03 FE 07 C0 0F C0 00 00 00"
	$"00 00 00 00 00 00 00 00 00 00 04 00 0F FF F0 00"
	$"00 00 06 00 1F FF F8 00 00 00 00 00 00 00 07 0E"
	$"00 00 00 00 00 FF 00 00 00 00 07 F8 00 C3 00 00"
	$"00 60 00 00 00 00 00 01 F8 7E 00 00 00 01 F0 00",
	{	/* array: 258 elements */
		/* [1] */
		0,
		/* [2] */
		0,
		/* [3] */
		0,
		/* [4] */
		0,
		/* [5] */
		0,
		/* [6] */
		0,
		/* [7] */
		0,
		/* [8] */
		0,
		/* [9] */
		0,
		/* [10] */
		0,
		/* [11] */
		0,
		/* [12] */
		0,
		/* [13] */
		0,
		/* [14] */
		0,
		/* [15] */
		0,
		/* [16] */
		0,
		/* [17] */
		0,
		/* [18] */
		0,
		/* [19] */
		0,
		/* [20] */
		0,
		/* [21] */
		0,
		/* [22] */
		0,
		/* [23] */
		0,
		/* [24] */
		0,
		/* [25] */
		0,
		/* [26] */
		0,
		/* [27] */
		0,
		/* [28] */
		0,
		/* [29] */
		0,
		/* [30] */
		0,
		/* [31] */
		0,
		/* [32] */
		0,
		/* [33] */
		0,
		/* [34] */
		5,
		/* [35] */
		21,
		/* [36] */
		36,
		/* [37] */
		51,
		/* [38] */
		66,
		/* [39] */
		81,
		/* [40] */
		96,
		/* [41] */
		107,
		/* [42] */
		123,
		/* [43] */
		137,
		/* [44] */
		150,
		/* [45] */
		163,
		/* [46] */
		179,
		/* [47] */
		195,
		/* [48] */
		210,
		/* [49] */
		225,
		/* [50] */
		240,
		/* [51] */
		252,
		/* [52] */
		265,
		/* [53] */
		280,
		/* [54] */
		295,
		/* [55] */
		308,
		/* [56] */
		325,
		/* [57] */
		341,
		/* [58] */
		355,
		/* [59] */
		369,
		/* [60] */
		384,
		/* [61] */
		392,
		/* [62] */
		407,
		/* [63] */
		423,
		/* [64] */
		438,
		/* [65] */
		445,
		/* [66] */
		445,
		/* [67] */
		461,
		/* [68] */
		477,
		/* [69] */
		493,
		/* [70] */
		509,
		/* [71] */
		525,
		/* [72] */
		541,
		/* [73] */
		557,
		/* [74] */
		573,
		/* [75] */
		589,
		/* [76] */
		605,
		/* [77] */
		621,
		/* [78] */
		637,
		/* [79] */
		653,
		/* [80] */
		669,
		/* [81] */
		685,
		/* [82] */
		701,
		/* [83] */
		716,
		/* [84] */
		731,
		/* [85] */
		747,
		/* [86] */
		763,
		/* [87] */
		778,
		/* [88] */
		793,
		/* [89] */
		809,
		/* [90] */
		825,
		/* [91] */
		825,
		/* [92] */
		825,
		/* [93] */
		825,
		/* [94] */
		825,
		/* [95] */
		825,
		/* [96] */
		825,
		/* [97] */
		825,
		/* [98] */
		826,
		/* [99] */
		839,
		/* [100] */
		849,
		/* [101] */
		862,
		/* [102] */
		875,
		/* [103] */
		888,
		/* [104] */
		901,
		/* [105] */
		917,
		/* [106] */
		917,
		/* [107] */
		917,
		/* [108] */
		932,
		/* [109] */
		941,
		/* [110] */
		956,
		/* [111] */
		965,
		/* [112] */
		981,
		/* [113] */
		981,
		/* [114] */
		981,
		/* [115] */
		981,
		/* [116] */
		981,
		/* [117] */
		981,
		/* [118] */
		981,
		/* [119] */
		997,
		/* [120] */
		997,
		/* [121] */
		997,
		/* [122] */
		997,
		/* [123] */
		997,
		/* [124] */
		997,
		/* [125] */
		997,
		/* [126] */
		997,
		/* [127] */
		997,
		/* [128] */
		997,
		/* [129] */
		997,
		/* [130] */
		997,
		/* [131] */
		997,
		/* [132] */
		997,
		/* [133] */
		997,
		/* [134] */
		997,
		/* [135] */
		997,
		/* [136] */
		997,
		/* [137] */
		997,
		/* [138] */
		997,
		/* [139] */
		997,
		/* [140] */
		997,
		/* [141] */
		997,
		/* [142] */
		997,
		/* [143] */
		997,
		/* [144] */
		997,
		/* [145] */
		997,
		/* [146] */
		997,
		/* [147] */
		997,
		/* [148] */
		997,
		/* [149] */
		997,
		/* [150] */
		997,
		/* [151] */
		997,
		/* [152] */
		997,
		/* [153] */
		997,
		/* [154] */
		997,
		/* [155] */
		997,
		/* [156] */
		997,
		/* [157] */
		997,
		/* [158] */
		997,
		/* [159] */
		997,
		/* [160] */
		997,
		/* [161] */
		997,
		/* [162] */
		1013,
		/* [163] */
		1013,
		/* [164] */
		1013,
		/* [165] */
		1013,
		/* [166] */
		1013,
		/* [167] */
		1022,
		/* [168] */
		1022,
		/* [169] */
		1022,
		/* [170] */
		1022,
		/* [171] */
		1022,
		/* [172] */
		1022,
		/* [173] */
		1022,
		/* [174] */
		1022,
		/* [175] */
		1034,
		/* [176] */
		1034,
		/* [177] */
		1034,
		/* [178] */
		1034,
		/* [179] */
		1034,
		/* [180] */
		1049,
		/* [181] */
		1060,
		/* [182] */
		1060,
		/* [183] */
		1060,
		/* [184] */
		1060,
		/* [185] */
		1060,
		/* [186] */
		1072,
		/* [187] */
		1081,
		/* [188] */
		1081,
		/* [189] */
		1081,
		/* [190] */
		1081,
		/* [191] */
		1093,
		/* [192] */
		1093,
		/* [193] */
		1093,
		/* [194] */
		1093,
		/* [195] */
		1093,
		/* [196] */
		1093,
		/* [197] */
		1109,
		/* [198] */
		1123,
		/* [199] */
		1130,
		/* [200] */
		1144,
		/* [201] */
		1144,
		/* [202] */
		1144,
		/* [203] */
		1157,
		/* [204] */
		1157,
		/* [205] */
		1157,
		/* [206] */
		1157,
		/* [207] */
		1157,
		/* [208] */
		1170,
		/* [209] */
		1178,
		/* [210] */
		1178,
		/* [211] */
		1188,
		/* [212] */
		1197,
		/* [213] */
		1209,
		/* [214] */
		1209,
		/* [215] */
		1209,
		/* [216] */
		1209,
		/* [217] */
		1209,
		/* [218] */
		1209,
		/* [219] */
		1209,
		/* [220] */
		1209,
		/* [221] */
		1209,
		/* [222] */
		1209,
		/* [223] */
		1217,
		/* [224] */
		1217,
		/* [225] */
		1229,
		/* [226] */
		1229,
		/* [227] */
		1229,
		/* [228] */
		1229,
		/* [229] */
		1229,
		/* [230] */
		1229,
		/* [231] */
		1229,
		/* [232] */
		1229,
		/* [233] */
		1229,
		/* [234] */
		1229,
		/* [235] */
		1229,
		/* [236] */
		1229,
		/* [237] */
		1229,
		/* [238] */
		1229,
		/* [239] */
		1229,
		/* [240] */
		1229,
		/* [241] */
		1229,
		/* [242] */
		1238,
		/* [243] */
		1238,
		/* [244] */
		1238,
		/* [245] */
		1238,
		/* [246] */
		1238,
		/* [247] */
		1238,
		/* [248] */
		1247,
		/* [249] */
		1263,
		/* [250] */
		1263,
		/* [251] */
		1279,
		/* [252] */
		1279,
		/* [253] */
		1279,
		/* [254] */
		1279,
		/* [255] */
		1295,
		/* [256] */
		1311,
		/* [257] */
		1311,
		/* [258] */
		1316
	},
	{	/* array: 258 elements */
		/* [1] */
		16,
		/* [2] */
		16,
		/* [3] */
		16,
		/* [4] */
		16,
		/* [5] */
		16,
		/* [6] */
		16,
		/* [7] */
		-1,
		/* [8] */
		-1,
		/* [9] */
		-1,
		/* [10] */
		16,
		/* [11] */
		-1,
		/* [12] */
		-1,
		/* [13] */
		-1,
		/* [14] */
		16,
		/* [15] */
		-1,
		/* [16] */
		-1,
		/* [17] */
		-1,
		/* [18] */
		-1,
		/* [19] */
		-1,
		/* [20] */
		-1,
		/* [21] */
		-1,
		/* [22] */
		-1,
		/* [23] */
		-1,
		/* [24] */
		-1,
		/* [25] */
		-1,
		/* [26] */
		-1,
		/* [27] */
		-1,
		/* [28] */
		-1,
		/* [29] */
		-1,
		/* [30] */
		-1,
		/* [31] */
		-1,
		/* [32] */
		-1,
		/* [33] */
		16,
		/* [34] */
		16,
		/* [35] */
		16,
		/* [36] */
		16,
		/* [37] */
		16,
		/* [38] */
		16,
		/* [39] */
		16,
		/* [40] */
		16,
		/* [41] */
		16,
		/* [42] */
		16,
		/* [43] */
		16,
		/* [44] */
		16,
		/* [45] */
		16,
		/* [46] */
		16,
		/* [47] */
		16,
		/* [48] */
		16,
		/* [49] */
		16,
		/* [50] */
		16,
		/* [51] */
		20,
		/* [52] */
		16,
		/* [53] */
		16,
		/* [54] */
		16,
		/* [55] */
		17,
		/* [56] */
		16,
		/* [57] */
		16,
		/* [58] */
		16,
		/* [59] */
		16,
		/* [60] */
		16,
		/* [61] */
		16,
		/* [62] */
		16,
		/* [63] */
		16,
		/* [64] */
		523,
		/* [65] */
		16,
		/* [66] */
		16,
		/* [67] */
		16,
		/* [68] */
		16,
		/* [69] */
		16,
		/* [70] */
		16,
		/* [71] */
		16,
		/* [72] */
		16,
		/* [73] */
		16,
		/* [74] */
		16,
		/* [75] */
		16,
		/* [76] */
		16,
		/* [77] */
		16,
		/* [78] */
		16,
		/* [79] */
		16,
		/* [80] */
		16,
		/* [81] */
		16,
		/* [82] */
		272,
		/* [83] */
		272,
		/* [84] */
		16,
		/* [85] */
		16,
		/* [86] */
		16,
		/* [87] */
		16,
		/* [88] */
		16,
		/* [89] */
		16,
		/* [90] */
		16,
		/* [91] */
		16,
		/* [92] */
		16,
		/* [93] */
		16,
		/* [94] */
		16,
		/* [95] */
		16,
		/* [96] */
		16,
		/* [97] */
		1552,
		/* [98] */
		16,
		/* [99] */
		272,
		/* [100] */
		16,
		/* [101] */
		16,
		/* [102] */
		16,
		/* [103] */
		16,
		/* [104] */
		16,
		/* [105] */
		16,
		/* [106] */
		16,
		/* [107] */
		16,
		/* [108] */
		784,
		/* [109] */
		16,
		/* [110] */
		784,
		/* [111] */
		16,
		/* [112] */
		16,
		/* [113] */
		16,
		/* [114] */
		16,
		/* [115] */
		16,
		/* [116] */
		16,
		/* [117] */
		16,
		/* [118] */
		16,
		/* [119] */
		16,
		/* [120] */
		16,
		/* [121] */
		16,
		/* [122] */
		16,
		/* [123] */
		16,
		/* [124] */
		16,
		/* [125] */
		16,
		/* [126] */
		16,
		/* [127] */
		16,
		/* [128] */
		16,
		/* [129] */
		16,
		/* [130] */
		16,
		/* [131] */
		16,
		/* [132] */
		16,
		/* [133] */
		16,
		/* [134] */
		16,
		/* [135] */
		16,
		/* [136] */
		16,
		/* [137] */
		16,
		/* [138] */
		16,
		/* [139] */
		16,
		/* [140] */
		16,
		/* [141] */
		16,
		/* [142] */
		16,
		/* [143] */
		16,
		/* [144] */
		16,
		/* [145] */
		16,
		/* [146] */
		16,
		/* [147] */
		16,
		/* [148] */
		16,
		/* [149] */
		16,
		/* [150] */
		16,
		/* [151] */
		16,
		/* [152] */
		16,
		/* [153] */
		16,
		/* [154] */
		16,
		/* [155] */
		16,
		/* [156] */
		16,
		/* [157] */
		16,
		/* [158] */
		16,
		/* [159] */
		16,
		/* [160] */
		16,
		/* [161] */
		16,
		/* [162] */
		16,
		/* [163] */
		16,
		/* [164] */
		16,
		/* [165] */
		16,
		/* [166] */
		16,
		/* [167] */
		16,
		/* [168] */
		16,
		/* [169] */
		16,
		/* [170] */
		16,
		/* [171] */
		16,
		/* [172] */
		16,
		/* [173] */
		16,
		/* [174] */
		16,
		/* [175] */
		16,
		/* [176] */
		16,
		/* [177] */
		16,
		/* [178] */
		16,
		/* [179] */
		16,
		/* [180] */
		16,
		/* [181] */
		16,
		/* [182] */
		16,
		/* [183] */
		16,
		/* [184] */
		16,
		/* [185] */
		16,
		/* [186] */
		16,
		/* [187] */
		16,
		/* [188] */
		16,
		/* [189] */
		16,
		/* [190] */
		16,
		/* [191] */
		16,
		/* [192] */
		16,
		/* [193] */
		16,
		/* [194] */
		16,
		/* [195] */
		16,
		/* [196] */
		16,
		/* [197] */
		16,
		/* [198] */
		16,
		/* [199] */
		16,
		/* [200] */
		16,
		/* [201] */
		16,
		/* [202] */
		16,
		/* [203] */
		16,
		/* [204] */
		16,
		/* [205] */
		16,
		/* [206] */
		16,
		/* [207] */
		16,
		/* [208] */
		16,
		/* [209] */
		16,
		/* [210] */
		16,
		/* [211] */
		16,
		/* [212] */
		16,
		/* [213] */
		16,
		/* [214] */
		16,
		/* [215] */
		16,
		/* [216] */
		16,
		/* [217] */
		16,
		/* [218] */
		16,
		/* [219] */
		16,
		/* [220] */
		16,
		/* [221] */
		16,
		/* [222] */
		8,
		/* [223] */
		16,
		/* [224] */
		16,
		/* [225] */
		1,
		/* [226] */
		16,
		/* [227] */
		16,
		/* [228] */
		16,
		/* [229] */
		16,
		/* [230] */
		16,
		/* [231] */
		16,
		/* [232] */
		16,
		/* [233] */
		16,
		/* [234] */
		16,
		/* [235] */
		16,
		/* [236] */
		16,
		/* [237] */
		16,
		/* [238] */
		16,
		/* [239] */
		16,
		/* [240] */
		16,
		/* [241] */
		16,
		/* [242] */
		16,
		/* [243] */
		16,
		/* [244] */
		16,
		/* [245] */
		16,
		/* [246] */
		16,
		/* [247] */
		16,
		/* [248] */
		16,
		/* [249] */
		16,
		/* [250] */
		16,
		/* [251] */
		16,
		/* [252] */
		16,
		/* [253] */
		16,
		/* [254] */
		16,
		/* [255] */
		16,
		/* [256] */
		16,
		/* [257] */
		263,
		/* [258] */
		-1
	}
};

resource 'FOND' (201, "MouseFont") {
	proportionalFont,
	dontUseFractWidthTable,
	useIntegerExtra,
	useFractEnable,
	canAdjustCharSpacing,
	noCharWidthTable,
	noImageHeightTable,
	201,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	2,
	{	/* array FontEntries: 1 elements */
		/* [1] */
		16, 0, 25744
	},
	{	/* array: 1 elements */
		/* [1] */
		{	/* array OffsetTable: 1 elements */
			/* [1] */
;
		},
		{	/* array BBoxTable: 1 elements */
			/* [1] */
			noExtendedStyle, noCondensedStyle, noShadowStyle, noOutlineStyle, noUnderline, noItalicStyle, noBoldStyle, {0, -1024, 4096, 3072}
		}
	},
	{	/* array: 0 elements */
	},
	{	/* array: 0 elements */
	},
	{	/* array: 0 elements */
	}
};

data 'ALRT' (260) {
	$"0054 005E 013A 0230 0104 CCCC"                  /* .T.^.:.0.. */
};

data 'DITL' (260) {
	$"0002 0000 0000 00B7 000B 00CB 0047 0402"        /* ...........G.. */
	$"4F4B 0000 0000 0007 005A 0058 01AB 0804"        /* OK.......Z.X... */
	$"5E30 5E31 0000 0000 005E 005C 00B6 01AC"        /* ^0^1.....^.\.. */
	$"0804 5E32 5E33"                                 /* ..^2^3 */
};


/* Get the driver assembly lang file. */
include "micronet-device.drvr" 'DRVR' (0:60) AS 'DRVR' ($$ID, $$Name, $$Attributes | 64);

/* ***************************************************************************** */


